<?php
/* --------------------------------------------------------------
   TrackingCodeFactory.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode;

use DateTime;
use Exception;
use Gambio\Admin\TrackingCode\Model\OrderId;
use Gambio\Admin\TrackingCode\Model\ParcelServiceDetails;
use Gambio\Admin\TrackingCode\Model\TrackingCode;
use Gambio\Admin\TrackingCode\Model\TrackingCodeId;
use Gambio\Core\Language\Model\LanguageId;

/**
 * Class TrackingCodeFactory
 *
 * @package Gambio\Admin\TrackingCode
 */
class TrackingCodeFactory
{
    /**
     * @param int                  $orderId
     * @param string               $code
     * @param int                  $languageId
     * @param ParcelServiceDetails $parcelServiceDetails
     * @param int|null             $id
     * @param DateTime|null        $createdOn
     *
     * @return TrackingCode
     * @throws Exception
     */
    public function createTrackingCode(
        int $orderId,
        string $code,
        int $languageId,
        ParcelServiceDetails $parcelServiceDetails,
        ?int $id = null,
        ?DateTime $createdOn = null
    ): TrackingCode {
        return TrackingCode::create(TrackingCodeId::create($id),
                                    OrderId::create($orderId),
                                    $code,
                                    LanguageId::create($languageId),
                                    $parcelServiceDetails,
                                    $createdOn ?? new DateTime());
    }
    
    
    /**
     * @param int    $id
     * @param string $name
     * @param string $url
     * @param string $comment
     *
     * @return ParcelServiceDetails
     */
    public function createParcelServiceDetails(
        int $id,
        string $name,
        string $url,
        string $comment
    ): ParcelServiceDetails {
        return ParcelServiceDetails::create($id, $name, $url, $comment);
    }
}
